/*
 * Decompiled with CFR 0.152.
 */
package filenet.sim.apps.designer;

import filenet.sim.api.IVWSIMScenario;
import filenet.sim.api.VWSIMSession;
import filenet.sim.api.VWScenarioDefinition;
import filenet.sim.apps.designer.VWSIMDesignerMainMenuBar;
import filenet.sim.apps.designer.VWSIMDesignerMainToolbar;
import filenet.sim.apps.designer.VWSIMDesignerStatusBar;
import filenet.sim.apps.designer.VWSIMIDMNewConfirmDialog;
import filenet.sim.apps.designer.VWSIMNewConfirmDialog;
import filenet.sim.apps.designer.VWSIMPreferencesDialog;
import filenet.sim.apps.designer.images.VWSIMImageLoader;
import filenet.sim.apps.designer.resources.VWSIMResource;
import filenet.sim.toolkit.designer.VWSIMDesignerPreferences;
import filenet.sim.toolkit.designer.message.VWSIMDesignerMessagePanel;
import filenet.sim.toolkit.designer.properties.IVWSIMPropertyChangeListener;
import filenet.sim.toolkit.designer.properties.VWSIMDesignerPropertiesPanel;
import filenet.sim.toolkit.designer.properties.VWSIMPropertyChangeEvent;
import filenet.sim.toolkit.designer.properties.VWSIMPropertyData;
import filenet.sim.toolkit.designer.properties.VWSIMScenarioPropertiesDialog;
import filenet.sim.toolkit.utils.VWSIMHelp;
import filenet.sim.toolkit.utils.VWSIMLauncher;
import filenet.vw.api.VWException;
import filenet.vw.api.VWUserInfo;
import filenet.vw.base.VWDebug;
import filenet.vw.base.VWString;
import filenet.vw.idm.toolkit.IVWIDMDialog;
import filenet.vw.idm.toolkit.IVWIDMDocument;
import filenet.vw.idm.toolkit.IVWIDMFactory;
import filenet.vw.idm.toolkit.IVWIDMItem;
import filenet.vw.idm.toolkit.VWIDMBaseFactory;
import filenet.vw.toolkit.utils.IVWFrameInterface;
import filenet.vw.toolkit.utils.VWAboutHelper;
import filenet.vw.toolkit.utils.VWBaseAppLauncherApplet;
import filenet.vw.toolkit.utils.VWBaseCore;
import filenet.vw.toolkit.utils.VWSessionInfo;
import filenet.vw.toolkit.utils.VWStringUtils;
import filenet.vw.toolkit.utils.VWWindowAdapter;
import filenet.vw.toolkit.utils.dialog.VWMessageDialog;
import filenet.vw.toolkit.utils.dialog.VWModalDialog;
import filenet.vw.toolkit.utils.event.IVWToolbarActionListener;
import filenet.vw.toolkit.utils.event.VWToolbarActionEvent;
import filenet.vw.toolkit.utils.wfdefinition.VWDefaultSessionProxy;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.FileDialog;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.beans.Beans;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Calendar;
import java.util.Hashtable;
import java.util.Locale;
import javax.swing.ImageIcon;
import javax.swing.JApplet;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JRootPane;
import javax.swing.RepaintManager;

public class VWSIMDesignerCore
extends VWBaseCore
implements ActionListener,
IVWFrameInterface,
IVWToolbarActionListener,
IVWSIMPropertyChangeListener {
    private static final String s_scenarioDesignerPropertiesPanelClassName = VWSIMDesignerPropertiesPanel.class.getName();
    private static final String s_scenarioDesignerMessagePanelClassName = VWSIMDesignerMessagePanel.class.getName();
    private static final String s_fileExtension = ".esd";
    private JRootPane m_rootPane = null;
    private Container m_contentPane = null;
    private VWSIMDesignerMainMenuBar m_mainMenuBar = null;
    private VWSIMDesignerMainToolbar m_mainToolbar = null;
    private VWSIMDesignerStatusBar m_statusBar = null;
    private VWSIMDesignerPropertiesPanel m_propertiesPanel = null;
    private VWSIMDesignerMessagePanel m_messagePanel = null;
    private FileDialog m_localOpenDialog = null;
    private FileDialog m_localSaveDialog = null;
    private VWSIMNewConfirmDialog m_newConfirmDialog = null;
    private VWSIMIDMNewConfirmDialog m_idmNewConfirmDialog = null;
    private IVWIDMDocument m_idmDoc = null;
    private boolean m_bIsCheckedOut = false;
    private VWSIMPropertyData m_propertyData = null;
    private boolean m_bHasQuit = false;

    public void init(VWSessionInfo sessionInfo) {
        try {
            try {
                Locale browserLocale = sessionInfo.getBrowserLocale();
                if (browserLocale != null) {
                    sessionInfo.getSession().setClientLocale(browserLocale);
                }
            }
            catch (Exception ex) {
                VWDebug.logException(ex);
            }
            this.initParentContainers(sessionInfo);
            VWDefaultSessionProxy.setSession(sessionInfo.getSession());
            super.init(sessionInfo);
            this.m_contentPane.setLayout(new BorderLayout());
            this.initApplicationPane();
            this.openInitFile();
            if (this.m_propertyData.getScenarioDefinition() == null) {
                this.performNewMenuItemAction();
            }
            this.m_propertyData.repaintContainer();
            this.m_propertyData.getToolbarActionNotifier().addToolbarActionListener(this);
            super.performInitialRefresh();
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    public boolean destroy() {
        boolean bResult = this.performExitMenuItemAction(false);
        if (bResult) {
            if (this.m_propertiesPanel != null) {
                this.m_propertiesPanel.releaseReferences();
            }
            if (this.m_messagePanel != null) {
                this.m_messagePanel.releaseReferences();
            }
            if (this.m_mainMenuBar != null) {
                this.m_mainMenuBar.releaseReferences();
            }
            if (this.m_mainToolbar != null) {
                this.m_mainToolbar.releaseReferences();
            }
            if (this.m_statusBar != null) {
                this.m_statusBar.releaseReferences();
            }
            this.releaseReferences();
        }
        return bResult;
    }

    public void actionPerformed(ActionEvent event) {
        Object src = event.getSource();
        if (src == this.m_mainMenuBar.m_newMenuItem || src == this.m_mainToolbar.m_newButton) {
            this.performNewMenuItemAction();
        } else if (src == this.m_mainMenuBar.m_openMenuItem || src == this.m_mainToolbar.m_openButton) {
            this.performOpenMenuItemAction();
        } else if (src == this.m_mainMenuBar.m_openMenuItem) {
            this.performCloseMenuItemAction();
        } else if (src == this.m_mainMenuBar.m_closeMenuItem) {
            this.performNewMenuItemAction();
        } else if (src == this.m_mainMenuBar.m_saveMenuItem || src == this.m_mainToolbar.m_saveButton) {
            this.performSaveMenuItemAction();
        } else if (src == this.m_mainMenuBar.m_saveAsMenuItem) {
            this.performSaveAsMenuItemAction();
        } else if (src == this.m_mainMenuBar.m_fileNETOpenMenuItem || src == this.m_mainToolbar.m_fileNETOpenButton) {
            this.performFileNETOpenMenuItemAction();
        } else if (src == this.m_mainMenuBar.m_fileNETAddNewMenuItem || src == this.m_mainToolbar.m_fileNETAddNewButton) {
            this.performFileNETAddNewMenuItemAction(true);
        } else if (src == this.m_mainMenuBar.m_fileNETCheckInMenuItem || src == this.m_mainToolbar.m_fileNETCheckInButton) {
            this.performFileNETCheckInMenuItemAction();
        } else if (src == this.m_mainMenuBar.m_fileNETCancelCheckOutMenuItem || src == this.m_mainToolbar.m_fileNETCancelCheckOutButton) {
            this.performFileNETCancelCheckOutMenuItemAction();
        } else if (src == this.m_mainMenuBar.m_fileNETSaveMenuItem || src == this.m_mainToolbar.m_fileNETSaveButton) {
            this.performFileNETSaveMenuItemAction();
        } else if (src == this.m_mainMenuBar.m_validateMenuItem || src == this.m_mainToolbar.m_validateButton) {
            this.performValidateMenuItemAction(true);
        } else if (src == this.m_mainMenuBar.m_startSimulationMenuItem || src == this.m_mainToolbar.m_startSimulationButton) {
            this.performStartSimulationMenuItemAction();
        } else if (src == this.m_mainMenuBar.m_exitMenuItem) {
            this.performExitMenuItemAction(true);
        } else if (src == this.m_mainMenuBar.m_scenarioPropertiesMenuItem) {
            this.performScenarioPropertiesMenuItemAction(this.m_mainMenuBar.m_scenarioPropertiesMenuItem.isSelected());
        } else if (src == this.m_mainToolbar.m_scenarioPropertiesButton) {
            this.performScenarioPropertiesMenuItemAction(this.m_mainToolbar.m_scenarioPropertiesButton.isSelected());
        } else if (src == this.m_mainMenuBar.m_toolbarMenuItem) {
            this.performMainToolbarMenuItemAction(this.m_mainMenuBar.m_toolbarMenuItem.isSelected(), true);
        } else if (src == this.m_mainMenuBar.m_mapToolbarMenuItem) {
            this.performMapToolbarMenuItemAction(this.m_mainMenuBar.m_mapToolbarMenuItem.isSelected(), true);
        } else if (src == this.m_mainMenuBar.m_statusBarMenuItem) {
            this.performStatusBarMenuItemAction(this.m_mainMenuBar.m_statusBarMenuItem.isSelected(), true);
        } else if (src == this.m_mainMenuBar.m_importWorkflowMenuItem) {
            this.performImportWorkflowMenuItemAction();
        } else if (src == this.m_mainMenuBar.m_replaceWorkflowMenuItem) {
            this.performReplaceWorkflowMenuItemAction();
        } else if (src == this.m_mainMenuBar.m_removeWorkflowMenuItem) {
            this.performRemoveWorkflowMenuItemAction();
        } else if (src == this.m_mainMenuBar.m_preferencesMenuItem) {
            this.performPreferencesMenuItemAction();
        } else if (src == this.m_mainMenuBar.m_contentsAndIndexMenuItem) {
            this.performContentsAndIndexMenuItemAction();
        } else if (src == this.m_mainMenuBar.m_aboutMenuItem) {
            this.performAboutMenuItemAction();
        } else {
            super.actionPerformed(event);
        }
    }

    public void windowClosing(WindowEvent event) {
        if (event == null) {
            return;
        }
        if (event.getSource() instanceof VWSIMScenarioPropertiesDialog) {
            if (this.m_mainMenuBar.m_scenarioPropertiesMenuItem != null) {
                this.m_mainMenuBar.m_scenarioPropertiesMenuItem.setSelected(false);
            }
            if (this.m_mainToolbar.m_scenarioPropertiesButton != null) {
                this.m_mainToolbar.m_scenarioPropertiesButton.setSelected(false);
            }
        }
    }

    public void toolbarActionPerformed(VWToolbarActionEvent event) {
        switch (event.getID()) {
            case 600: {
                this.performMainToolbarMenuItemAction(true, false);
                break;
            }
            case 601: {
                this.performMainToolbarMenuItemAction(false, false);
                break;
            }
            case 602: {
                this.performMapToolbarMenuItemAction(true, false);
                break;
            }
            case 603: {
                this.performMapToolbarMenuItemAction(false, false);
                break;
            }
            case 604: {
                this.performStatusBarMenuItemAction(true, false);
                break;
            }
            case 605: {
                this.performStatusBarMenuItemAction(false, false);
                break;
            }
            case 652: {
                this.performValidateMenuItemAction(true);
            }
        }
    }

    public void propertyDataChanged(VWSIMPropertyChangeEvent event) {
        switch (event.getID()) {
            case 101: 
            case 125: 
            case 126: {
                if (this.m_propertiesPanel == null) break;
                String workflowName = this.m_propertiesPanel.getSelectedWorkflowName();
                this.m_mainMenuBar.m_replaceWorkflowMenuItem.setEnabled(workflowName != null);
                this.m_mainMenuBar.m_removeWorkflowMenuItem.setEnabled(workflowName != null);
            }
        }
    }

    private void openFileNETFile(String library, String docId, String version) {
        try {
            IVWIDMDocument IDMDoc;
            IVWIDMFactory idmFactory = VWIDMBaseFactory.instance();
            if (idmFactory != null && (IDMDoc = idmFactory.getIDMDocument(library, docId, version)) != null) {
                int nConfirmResult;
                boolean bCheckItOut = false;
                bCheckItOut = IDMDoc.isExclusiveLockOwner() ? true : (IDMDoc.canCheckin() ? (nConfirmResult = JOptionPane.showConfirmDialog(this.m_propertyData.getParentFrame(), VWSIMResource.s_assumeCheckOut, VWSIMResource.s_fileNETOpenCheckOutToolTip, 0)) == 0 : IDMDoc.canCheckout());
                this.openFileNETDocument(IDMDoc, bCheckItOut);
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
            JOptionPane.showMessageDialog(this.m_propertyData.getParentFrame(), ex.getLocalizedMessage(), VWSIMResource.s_fileNETOpenCheckOutToolTip, 0);
        }
    }

    private void openFileNETFile(String canonicalID) {
        try {
            IVWIDMDocument doc;
            IVWIDMFactory idmFactory = VWIDMBaseFactory.instance();
            if (idmFactory != null && (doc = (IVWIDMDocument)idmFactory.getIDMItem(canonicalID)) != null) {
                int confirmResult;
                boolean checkItOut = false;
                checkItOut = doc.isExclusiveLockOwner() ? true : (doc.canCheckin() ? (confirmResult = JOptionPane.showConfirmDialog(this.m_propertyData.getParentFrame(), VWSIMResource.s_assumeCheckOut, VWSIMResource.s_fileNETOpenCheckOutToolTip, 0)) == 0 : doc.canCheckout());
                this.openFileNETDocument(doc, checkItOut);
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
            JOptionPane.showMessageDialog(this.m_propertyData.getParentFrame(), ex.getLocalizedMessage(), VWSIMResource.s_fileNETOpenCheckOutToolTip, 0);
        }
    }

    private void openInitFile() {
        try {
            VWSessionInfo sessionInfo = this.m_propertyData.getSessionInfo();
            if (sessionInfo == null) {
                return;
            }
            String type = sessionInfo.getProperty("ScenarioDesignerInvokeType");
            String library = sessionInfo.getProperty("library");
            String docId = sessionInfo.getProperty("docId");
            String version = sessionInfo.getProperty("version");
            String canonicalID = sessionInfo.getProperty("DocumentCanonicalId");
            String xml = sessionInfo.getProperty("ScenarioXML");
            if (VWStringUtils.compare(type, "0") == 0) {
                if (canonicalID != null) {
                    IVWIDMItem idmItem = VWIDMBaseFactory.instance().getIDMItem(canonicalID);
                    this.m_propertyData.setIDMContext(idmItem);
                }
            } else if (VWStringUtils.compare(type, "1") == 0) {
                this.openFileNETFile(canonicalID);
            } else if (VWStringUtils.compare(type, "2") == 0) {
                this.setInitialIDMContext();
                this.performNewMenuItemAction();
                VWScenarioDefinition scenarioDefinition = VWScenarioDefinition.read(xml);
                this.updateBeans(scenarioDefinition, false);
            } else if (library != null && library.length() > 0) {
                this.openFileNETFile(library, docId, version);
            } else {
                this.setInitialIDMContext();
                this.openLocalFile(docId);
            }
        }
        catch (VWException ex) {
            VWMessageDialog.showOptionDialog(this.m_propertyData.getParentFrame(), ex.getLocalizedMessage(), 1);
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void openLocalFile(String filePath) {
        FileInputStream stream = null;
        try {
            if (filePath != null) {
                this.resetIDMDocObjects();
                this.m_propertyData.displayWaitCursor();
                stream = new FileInputStream(filePath);
                VWScenarioDefinition scenarioDefinition = VWScenarioDefinition.read(stream);
                stream.close();
                this.updateBeans(scenarioDefinition, false);
                int index = filePath.lastIndexOf("\\");
                if (index == -1) {
                    this.m_localSaveDialog.setDirectory("");
                    this.m_localSaveDialog.setFile(filePath);
                } else {
                    this.m_localSaveDialog.setDirectory(filePath.substring(0, index) + "\\");
                    this.m_localSaveDialog.setFile(filePath.substring(index + 1, filePath.length()));
                }
                this.updateTitlebar(this.m_localSaveDialog.getFile());
            }
        }
        catch (SecurityException e) {
            VWDebug.logException(e);
            JOptionPane.showMessageDialog(this.m_propertyData.getParentFrame(), VWSIMResource.s_fileSecurityErrMsg, VWSIMResource.s_fileSecurityErrTitle, 0);
            this.resetDirty();
            this.performNewMenuItemAction();
        }
        catch (Exception e) {
            VWDebug.logException(e);
            VWMessageDialog.showOptionDialog(this.m_propertyData.getParentFrame(), e.getLocalizedMessage(), VWSIMResource.s_fileOpenError, 1);
            this.resetDirty();
            this.performNewMenuItemAction();
        }
        finally {
            try {
                if (stream != null) {
                    stream.close();
                }
            }
            catch (IOException ex) {}
            this.m_propertyData.restoreDefaultCursor();
        }
    }

    private void initParentContainers(VWSessionInfo sessionInfo) {
        Container mainContainer = sessionInfo.getParentContainer();
        if (mainContainer instanceof JApplet) {
            this.m_rootPane = ((JApplet)mainContainer).getRootPane();
            this.m_contentPane = ((JApplet)mainContainer).getContentPane();
        } else if (mainContainer instanceof JFrame) {
            this.m_rootPane = ((JFrame)mainContainer).getRootPane();
            this.m_contentPane = ((JFrame)mainContainer).getContentPane();
        }
        this.m_propertyData = new VWSIMPropertyData(VWModalDialog.getParentFrameUsingContainer(mainContainer), sessionInfo);
        this.m_propertyData.getPropertyChangeEventNotifier().addPropertyChangeListener(this);
        RepaintManager repaintManager = RepaintManager.currentManager(mainContainer);
        if (repaintManager != null && !repaintManager.isDoubleBufferingEnabled()) {
            repaintManager.setDoubleBufferingEnabled(true);
        }
    }

    private void initApplicationPane() {
        try {
            this.m_propertiesPanel = (VWSIMDesignerPropertiesPanel)Beans.instantiate(this.getClass().getClassLoader(), s_scenarioDesignerPropertiesPanelClassName);
            this.m_propertiesPanel.init(this.m_propertyData);
            this.m_propertiesPanel.addScenarioPropertiesWindowListener(new VWWindowAdapter(this));
            this.m_messagePanel = (VWSIMDesignerMessagePanel)Beans.instantiate(this.getClass().getClassLoader(), s_scenarioDesignerMessagePanelClassName);
            this.m_messagePanel.init(this.m_propertyData, 1);
        }
        catch (ClassNotFoundException ex) {
            String errorMsg = VWSIMResource.s_cannotFindClass.toString(ex.getLocalizedMessage());
            VWDebug.logError(errorMsg);
        }
        catch (IOException ex) {
            String errorMsg = VWSIMResource.s_cannotLoadClass.toString(ex.getLocalizedMessage());
            VWDebug.logError(errorMsg);
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
        this.m_mainMenuBar = new VWSIMDesignerMainMenuBar(this, this.m_propertyData.getSessionInfo().getCanSaveToDMS());
        this.m_rootPane.setJMenuBar(this.m_mainMenuBar);
        this.m_mainToolbar = new VWSIMDesignerMainToolbar(this, this.m_propertyData.getSessionInfo().getCanSaveToDMS());
        this.m_contentPane.add((Component)this.m_mainToolbar, "First");
        this.m_statusBar = new VWSIMDesignerStatusBar(this.m_propertyData, this.m_propertiesPanel.getMapAttributes());
        this.m_contentPane.add((Component)this.m_statusBar, "Last");
        this.initDialogs();
        Thread.yield();
        this.m_contentPane.add((Component)this.m_propertiesPanel, "Center");
    }

    private void initDialogs() {
        this.m_localOpenDialog = new FileDialog(this.m_propertyData.getParentFrame());
        this.m_localOpenDialog.setMode(0);
        this.m_localOpenDialog.setTitle(VWSIMResource.s_localOpen);
        this.m_localSaveDialog = new FileDialog(this.m_propertyData.getParentFrame());
        this.m_localSaveDialog.setMode(1);
        this.m_localSaveDialog.setTitle(VWSIMResource.s_localSave);
    }

    private void releaseReferences() {
        this.m_mainMenuBar = null;
        this.m_mainToolbar = null;
        this.m_statusBar = null;
        this.m_propertiesPanel = null;
        this.m_messagePanel = null;
    }

    private boolean handleLocalDocument() {
        boolean ok = true;
        try {
            if (this.m_newConfirmDialog == null) {
                this.m_newConfirmDialog = new VWSIMNewConfirmDialog(this.m_propertyData.getParentFrame());
                this.m_newConfirmDialog.init();
            }
            this.m_newConfirmDialog.setVisible(true);
            int result = this.m_newConfirmDialog.getConfirmResult();
            block1 : switch (result) {
                case 101: {
                    int status = this.m_newConfirmDialog.getStatus();
                    switch (status) {
                        case 300: {
                            ok = this.performFileNETAddNewMenuItemAction(false);
                            break block1;
                        }
                        case 301: {
                            ok = this.performSaveMenuItemAction();
                        }
                    }
                    break;
                }
                case 102: {
                    ok = true;
                    break;
                }
                case 103: {
                    ok = false;
                }
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
        return ok;
    }

    private boolean handleIDMDocument(String msg, boolean saveNoneCheckedout) {
        boolean bSuccess = false;
        try {
            if (this.m_idmDoc != null) {
                if (this.m_bIsCheckedOut && this.m_idmDoc.canCheckin()) {
                    if (this.m_idmNewConfirmDialog == null) {
                        this.m_idmNewConfirmDialog = new VWSIMIDMNewConfirmDialog(this.m_propertyData.getParentFrame());
                        this.m_idmNewConfirmDialog.init();
                    }
                    this.m_idmNewConfirmDialog.setMessage(msg);
                    this.m_idmNewConfirmDialog.setVisible(true);
                    switch (this.m_idmNewConfirmDialog.getConfirmResult()) {
                        case 100: {
                            switch (this.m_idmNewConfirmDialog.getStatus()) {
                                case 500: {
                                    bSuccess = this.performFileNETCheckInMenuItemAction();
                                    break;
                                }
                                case 501: {
                                    this.m_idmDoc.cancelCheckoutNoUI();
                                    bSuccess = true;
                                }
                            }
                            this.m_bIsCheckedOut = false;
                            this.updateIDMTitlebar();
                            this.updateMenuToolbar(102);
                            break;
                        }
                        case 103: {
                            bSuccess = false;
                        }
                    }
                } else {
                    bSuccess = saveNoneCheckedout ? this.handleLocalDocument() : true;
                }
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
        return bSuccess;
    }

    private void performNewMenuItemAction() {
        boolean newScenario = true;
        try {
            if (this.isDirty()) {
                newScenario = this.m_idmDoc != null ? this.handleIDMDocument(VWSIMResource.s_beforeNewScenario, true) : this.handleLocalDocument();
            } else if (this.m_idmDoc != null) {
                newScenario = this.handleIDMDocument(VWSIMResource.s_beforeNewScenario, false);
            }
            if (newScenario) {
                this.resetDirty();
                this.resetIDMDocObjects();
                VWScenarioDefinition scenarioDefinition = new VWScenarioDefinition();
                scenarioDefinition.setAnimationEnabled(true);
                scenarioDefinition.setCollectAnalysisData(true);
                Calendar start = Calendar.getInstance();
                start.set(10, 8);
                start.set(12, 0);
                start.set(13, 0);
                start.set(9, 0);
                scenarioDefinition.setStartTime(start.getTime());
                Calendar end = Calendar.getInstance();
                end.set(10, 5);
                end.set(12, 0);
                end.set(13, 0);
                end.set(9, 1);
                scenarioDefinition.setEndTime(end.getTime());
                this.m_localOpenDialog.setDirectory("");
                this.m_localOpenDialog.setFile("*.esd");
                this.m_localSaveDialog.setDirectory("");
                this.m_localSaveDialog.setFile(VWSIMResource.s_newFileName + s_fileExtension);
                this.updateTitlebar(this.m_localSaveDialog.getFile());
                this.updateMenuToolbar(100);
                this.updateBeans(scenarioDefinition, true);
            }
        }
        catch (VWException ex) {
            VWMessageDialog.showOptionDialog(this.m_propertyData.getParentFrame(), ex.getLocalizedMessage(), 1);
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void performOpenMenuItemAction() {
        boolean bOpen = true;
        FileInputStream stream = null;
        try {
            if (this.isDirty()) {
                bOpen = this.m_idmDoc != null ? this.handleIDMDocument(VWSIMResource.s_beforeAddNew, true) : this.handleLocalDocument();
            } else if (this.m_idmDoc != null) {
                bOpen = this.handleIDMDocument(VWSIMResource.s_beforeAddNew, false);
            }
            if (bOpen) {
                this.updateTitlebarStatus(VWSIMResource.s_openingLocally);
                this.resetDirty();
                this.m_localOpenDialog.setFile("*.esd");
                this.m_localOpenDialog.setVisible(true);
                String path = this.m_localOpenDialog.getDirectory();
                String file = this.m_localOpenDialog.getFile();
                if (file != null) {
                    this.resetIDMDocObjects();
                    this.m_propertyData.repaintContainer();
                    this.m_propertyData.displayWaitCursor();
                    stream = new FileInputStream(path + file);
                    VWScenarioDefinition scenarioDefinition = VWScenarioDefinition.read(stream);
                    stream.close();
                    this.m_localSaveDialog.setDirectory(path);
                    this.m_localSaveDialog.setFile(file);
                    this.updateTitlebar(this.m_localSaveDialog.getFile());
                    this.updateMenuToolbar(100);
                    this.updateBeans(scenarioDefinition, false);
                    this.performValidateMenuItemAction(false);
                }
                this.updateTitlebarStatus("");
            }
        }
        catch (FileNotFoundException ex) {
            VWMessageDialog.showOptionDialog(this.m_propertyData.getParentFrame(), ex.getLocalizedMessage(), 1);
        }
        catch (IOException ex) {
            VWMessageDialog.showOptionDialog(this.m_propertyData.getParentFrame(), ex.getLocalizedMessage(), 1);
        }
        catch (Exception ex) {
            VWMessageDialog.showOptionDialog(this.m_propertyData.getParentFrame(), ex.getLocalizedMessage(), 1);
            VWDebug.logException(ex);
        }
        finally {
            try {
                if (stream != null) {
                    stream.close();
                }
            }
            catch (IOException ex) {}
            this.m_propertyData.restoreDefaultCursor();
        }
    }

    private void performCloseMenuItemAction() {
        this.performNewMenuItemAction();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean performSaveMenuItemAction() {
        boolean bSaved = true;
        FileOutputStream stream = null;
        try {
            this.m_propertyData.getPropertyChangeEventNotifier().notifyPropertyChange(this, 103);
            if (this.m_propertyData.getScenarioDefinition() != null) {
                if (this.m_idmDoc != null) {
                    bSaved = this.handleIDMDocument(VWSIMResource.s_beforeSaveLocally, false);
                }
                if (bSaved) {
                    String path = this.m_localSaveDialog.getDirectory();
                    String filename = this.m_localSaveDialog.getFile();
                    if (filename == null || filename.length() == 0) {
                        this.m_localSaveDialog.setFile(VWSIMResource.s_newFileName + s_fileExtension);
                    }
                    if (path == null) {
                        bSaved = this.performSaveAsMenuItemAction();
                    } else {
                        this.m_propertyData.displayWaitCursor();
                        stream = new FileOutputStream(path + filename);
                        this.m_propertyData.getScenarioDefinition().write(stream);
                        stream.close();
                        this.resetDirty();
                        this.updateTitlebar(filename);
                        this.updateMenuToolbar(100);
                        this.m_propertyData.restoreDefaultCursor();
                    }
                }
            }
        }
        catch (IOException ex) {
            VWMessageDialog.showOptionDialog(this.m_propertyData.getParentFrame(), ex.getLocalizedMessage(), 1);
            bSaved = false;
        }
        catch (VWException ex) {
            VWMessageDialog.showOptionDialog(this.m_propertyData.getParentFrame(), ex.getLocalizedMessage(), 1);
            bSaved = false;
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
            bSaved = false;
        }
        finally {
            try {
                if (stream != null) {
                    stream.close();
                }
            }
            catch (IOException ex) {}
        }
        return bSaved;
    }

    private boolean performSaveAsMenuItemAction() {
        boolean save = true;
        if (this.m_idmDoc != null) {
            save = this.handleIDMDocument(VWSIMResource.s_beforeSaveLocally, false);
        }
        if (save) {
            this.updateTitlebarStatus(VWSIMResource.s_savingLocally);
            this.m_localSaveDialog.setVisible(true);
            String filename = this.m_localSaveDialog.getFile();
            this.m_propertyData.repaintContainer();
            if (filename != null) {
                this.performSaveMenuItemAction();
            } else {
                save = false;
            }
            this.updateTitlebarStatus("");
        }
        return save;
    }

    private void performFileNETOpenMenuItemAction() {
        boolean open = true;
        try {
            this.m_propertyData.getPropertyChangeEventNotifier().notifyPropertyChange(this, 103);
            if (this.isDirty()) {
                open = this.m_idmDoc != null ? this.handleIDMDocument(VWSIMResource.s_beforeOpenScenario, true) : this.handleLocalDocument();
            } else if (this.m_idmDoc != null) {
                open = this.handleIDMDocument(VWSIMResource.s_beforeOpenScenario, false);
            }
            if (open) {
                this.updateTitlebarStatus(VWSIMResource.s_fileNETOpening);
                this.m_propertyData.displayWaitCursor();
                IVWIDMDialog dialog = VWIDMBaseFactory.instance().getOpenDialog(this.m_propertyData.getIDMContext(), VWSIMResource.s_open_withHK, "ScenarioDefinition");
                dialog.setTitle(VWSIMResource.s_openFromDMSTitle);
                dialog.setButtonTooltip(VWSIMResource.s_open);
                this.m_propertyData.restoreDefaultCursor();
                int result = dialog.showDialog(this.m_propertyData.getParentFrame());
                switch (result) {
                    case 0: {
                        IVWIDMDocument doc = (IVWIDMDocument)dialog.getSelectedItem();
                        if (doc != null) {
                            boolean checkout;
                            boolean bl = checkout = dialog.getMode() == 1;
                            if (!checkout && doc.canCheckin()) {
                                int confirm = JOptionPane.showConfirmDialog(this.m_propertyData.getParentFrame(), VWSIMResource.s_assumeCheckOut, VWSIMResource.s_fileNETOpenCheckOutToolTip, 0);
                                checkout = confirm == 0;
                            }
                            this.openFileNETDocument(doc, checkout);
                            break;
                        }
                        open = false;
                        break;
                    }
                    default: {
                        open = false;
                    }
                }
            }
        }
        catch (VWException ex) {
            this.m_propertyData.restoreDefaultCursor();
            VWDebug.logException(ex);
            this.resetIDMDocObjects();
        }
        catch (Exception ex) {
            this.m_propertyData.restoreDefaultCursor();
            VWDebug.logException(ex);
            this.resetIDMDocObjects();
        }
        this.updateTitlebarStatus("");
    }

    private void openFileNETDocument(IVWIDMDocument doc, boolean bCheckOut) {
        try {
            if (doc != null) {
                this.m_idmDoc = doc;
                this.m_propertyData.setIDMContext(this.m_idmDoc);
                this.m_propertyData.displayWaitCursor();
                byte[] fileContents = this.m_idmDoc.getContents(bCheckOut);
                if (fileContents != null) {
                    ByteArrayInputStream inStream = new ByteArrayInputStream(fileContents);
                    VWScenarioDefinition scenarioDefinition = VWScenarioDefinition.read(inStream);
                    fileContents = null;
                    inStream.close();
                    this.updateBeans(scenarioDefinition, false);
                    this.m_bIsCheckedOut = bCheckOut;
                    this.updateIDMTitlebar();
                    this.updateMenuToolbar(this.m_bIsCheckedOut ? 101 : 102);
                }
            }
        }
        catch (VWException ex) {
            VWMessageDialog.showOptionDialog(this.m_propertyData.getParentFrame(), ex.getLocalizedMessage(), 1);
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
        this.m_propertyData.restoreDefaultCursor();
    }

    private boolean performFileNETAddNewMenuItemAction(boolean bReset) {
        boolean bAddNew = true;
        try {
            String desc;
            this.m_propertyData.getPropertyChangeEventNotifier().notifyPropertyChange(this, 103);
            VWScenarioDefinition scenarioDefinition = this.m_propertyData.getScenarioDefinition();
            if (scenarioDefinition == null) {
                return false;
            }
            String name = scenarioDefinition.getName();
            if (name == null) {
                name = "";
            }
            if ((desc = scenarioDefinition.getDescription()) == null) {
                desc = "";
            }
            if (this.m_idmDoc != null) {
                bAddNew = this.handleIDMDocument(VWSIMResource.s_beforeAddNew, false);
            }
            if (bAddNew) {
                this.updateTitlebarStatus(VWSIMResource.s_addingNew);
                this.m_propertyData.displayWaitCursor();
                ByteArrayOutputStream outStream = new ByteArrayOutputStream();
                scenarioDefinition.write(outStream);
                byte[] fileContents = outStream.toByteArray();
                outStream.close();
                Hashtable<String, String> parameters = new Hashtable<String, String>();
                parameters.put("DocumentTitle", name);
                parameters.put("ScenarioDescription", desc);
                IVWIDMFactory factory = VWIDMBaseFactory.instance();
                IVWIDMDialog dialog = factory.getAddDialog(this.m_propertyData.getParentFrame(), this.m_propertyData.getIDMContext(), fileContents, "ScenarioDefinition", parameters);
                dialog.setTitle(factory.getVWString(23).toString());
                dialog.setFilename(name);
                this.m_propertyData.restoreDefaultCursor();
                int nResult = dialog.showDialog(this.m_propertyData.getParentFrame());
                this.m_propertyData.repaintContainer();
                switch (nResult) {
                    case 0: {
                        this.resetDirty();
                        if (bReset) {
                            this.resetIDMDocObjects();
                            this.performNewMenuItemAction();
                            break;
                        }
                        this.m_idmDoc = (IVWIDMDocument)dialog.getSelectedItem();
                        this.m_propertyData.setIDMContext(this.m_idmDoc);
                        this.m_bIsCheckedOut = false;
                        this.updateIDMTitlebar();
                        this.updateMenuToolbar(this.m_bIsCheckedOut ? 101 : 102);
                        break;
                    }
                    default: {
                        bAddNew = false;
                    }
                }
            }
        }
        catch (VWException ex) {
            this.m_propertyData.restoreDefaultCursor();
            VWMessageDialog.showOptionDialog(this.m_propertyData.getParentFrame(), ex.getLocalizedMessage(), 1);
            bAddNew = false;
        }
        catch (Exception ex) {
            this.m_propertyData.restoreDefaultCursor();
            VWDebug.logException(ex);
            bAddNew = false;
        }
        this.updateTitlebarStatus("");
        return bAddNew;
    }

    private boolean performFileNETCheckInMenuItemAction() {
        boolean result = true;
        try {
            this.m_propertyData.getPropertyChangeEventNotifier().notifyPropertyChange(this, 103);
            VWScenarioDefinition scenarioDefinition = this.m_propertyData.getScenarioDefinition();
            if (scenarioDefinition != null && this.m_idmDoc != null && this.m_bIsCheckedOut && this.m_idmDoc.canCheckin()) {
                this.updateTitlebarStatus(VWSIMResource.s_checkingIn);
                this.m_propertyData.displayWaitCursor();
                ByteArrayOutputStream outStream = new ByteArrayOutputStream();
                scenarioDefinition.write(outStream);
                byte[] fileContents = outStream.toByteArray();
                outStream.close();
                String name = scenarioDefinition.getName();
                if (name == null) {
                    name = "";
                }
                if (!this.m_idmDoc.checkin(this.m_propertyData.getParentFrame(), fileContents, true, name, VWSIMResource.s_checkinScenarioDefinition)) {
                    result = false;
                }
                this.m_propertyData.restoreDefaultCursor();
                this.m_bIsCheckedOut = false;
                this.updateTitlebarStatus("");
                this.updateIDMTitlebar();
            }
        }
        catch (VWException ex) {
            this.m_propertyData.restoreDefaultCursor();
            VWMessageDialog.showOptionDialog(this.m_propertyData.getParentFrame(), ex.getLocalizedMessage(), 1);
            result = false;
        }
        catch (Exception ex) {
            this.m_propertyData.restoreDefaultCursor();
            VWDebug.logException(ex);
            result = false;
        }
        return result;
    }

    private void performFileNETCancelCheckOutMenuItemAction() {
        try {
            if (this.m_idmDoc != null && this.m_bIsCheckedOut && this.m_idmDoc.canCheckin()) {
                this.m_propertyData.getPropertyChangeEventNotifier().notifyPropertyChange(this, 103);
                this.m_idmDoc.cancelCheckoutNoUI();
                this.m_bIsCheckedOut = this.m_idmDoc.isCheckedOut();
                this.updateIDMTitlebar();
                this.updateMenuToolbar(102);
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    private void performFileNETSaveMenuItemAction() {
        try {
            this.m_propertyData.getPropertyChangeEventNotifier().notifyPropertyChange(this, 103);
            VWScenarioDefinition scenarioDefinition = this.m_propertyData.getScenarioDefinition();
            if (scenarioDefinition != null && this.m_idmDoc != null && this.m_bIsCheckedOut && this.m_idmDoc.canCheckin()) {
                this.m_propertyData.displayWaitCursor();
                this.updateTitlebarStatus(VWSIMResource.s_fileNETSaving);
                ByteArrayOutputStream outStream = new ByteArrayOutputStream();
                scenarioDefinition.write(outStream);
                byte[] fileContents = outStream.toByteArray();
                outStream.close();
                String name = scenarioDefinition.getName();
                if (name == null) {
                    name = "";
                }
                this.m_idmDoc.saveContents(fileContents, name);
                this.resetDirty();
                this.updateIDMTitlebar();
                this.updateTitlebarStatus("");
                this.m_propertyData.restoreDefaultCursor();
            }
        }
        catch (VWException ex) {
            this.m_propertyData.restoreDefaultCursor();
            VWMessageDialog.showOptionDialog(this.m_propertyData.getParentFrame(), ex.getLocalizedMessage(), 1);
        }
        catch (Exception ex) {
            this.m_propertyData.restoreDefaultCursor();
            VWDebug.logException(ex);
        }
    }

    private boolean performValidateMenuItemAction(boolean bDisplayMessage) {
        boolean bScenarioIsValid = false;
        if (this.m_messagePanel != null) {
            this.m_propertyData.displayWaitCursor();
            bScenarioIsValid = this.m_messagePanel.validateScenario(this.m_propertyData, bDisplayMessage);
            this.m_propertyData.restoreDefaultCursor();
        }
        return bScenarioIsValid;
    }

    private void performStartSimulationMenuItemAction() {
        try {
            if (this.performValidateMenuItemAction(false)) {
                if ((this.m_idmDoc == null || this.m_idmDoc != null && !this.m_bIsCheckedOut) && !this.performFileNETAddNewMenuItemAction(false)) {
                    return;
                }
                if (this.m_idmDoc != null) {
                    VWSIMSession simSession;
                    IVWSIMScenario scenario;
                    if (this.isDirty()) {
                        this.performFileNETSaveMenuItemAction();
                    }
                    if ((scenario = (simSession = new VWSIMSession()).getScenario(this.m_idmDoc.getLibraryId(), this.m_idmDoc.getId())) != null) {
                        VWSIMLauncher launcher = new VWSIMLauncher(this.m_propertyData.getParentFrame(), this.m_propertyData.getSessionInfo().getSession());
                        boolean bSuccess = launcher.startSimulation(this.m_propertyData.getScenarioDefinition(), scenario, this.m_propertyData.getIDMContext());
                        this.m_propertyData.repaintContainer();
                        if (bSuccess) {
                            launcher.getSimulation();
                            VWMessageDialog.showOptionDialog(this.m_propertyData.getParentFrame(), VWSIMResource.s_simulationStarted, VWSIMResource.s_startSimulationToolTip, 2);
                        }
                    }
                }
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
            VWMessageDialog.showOptionDialog(this.m_propertyData.getParentFrame(), ex.getLocalizedMessage(), 1);
        }
    }

    private boolean performExitMenuItemAction(boolean bCloseWindow) {
        boolean bResult = true;
        try {
            if (!this.m_bHasQuit) {
                this.m_propertyData.getPropertyChangeEventNotifier().notifyPropertyChange(this, 103);
                if (this.isDirty()) {
                    bResult = this.m_idmDoc != null ? this.handleIDMDocument(VWSIMResource.s_beforeExit, true) : this.handleLocalDocument();
                } else if (this.m_idmDoc != null) {
                    bResult = this.handleIDMDocument(VWSIMResource.s_beforeExit, false);
                }
                if (bResult) {
                    if (bCloseWindow) {
                        Container mainContainer = this.m_propertyData.getSessionInfo().getParentContainer();
                        if (mainContainer != null && mainContainer instanceof JFrame) {
                            Toolkit.getDefaultToolkit().getSystemEventQueue().postEvent(new WindowEvent((JFrame)mainContainer, 201));
                        } else if (mainContainer != null && mainContainer instanceof VWBaseAppLauncherApplet) {
                            ((VWBaseAppLauncherApplet)mainContainer).closeWindow();
                        }
                    }
                    this.m_bHasQuit = true;
                }
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
        return bResult;
    }

    private void performMainToolbarMenuItemAction(boolean bShow, boolean bNotify) {
        if (this.m_mainMenuBar.m_toolbarMenuItem != null) {
            this.m_mainMenuBar.m_toolbarMenuItem.setSelected(bShow);
            this.m_mainToolbar.setVisible(bShow);
        }
        if (bNotify) {
            this.m_propertyData.getToolbarActionNotifier().notifyToolbarAction(this, bShow ? 600 : 601);
        }
    }

    private void performMapToolbarMenuItemAction(boolean bShow, boolean bNotify) {
        if (this.m_mainMenuBar.m_mapToolbarMenuItem != null) {
            this.m_mainMenuBar.m_mapToolbarMenuItem.setSelected(bShow);
        }
        if (bNotify) {
            this.m_propertyData.getToolbarActionNotifier().notifyToolbarAction(this, bShow ? 602 : 603);
        }
    }

    private void performStatusBarMenuItemAction(boolean bShow, boolean bNotify) {
        if (this.m_mainMenuBar.m_statusBarMenuItem != null) {
            this.m_mainMenuBar.m_statusBarMenuItem.setSelected(bShow);
            this.m_statusBar.setVisible(bShow);
        }
        if (bNotify) {
            this.m_propertyData.getToolbarActionNotifier().notifyToolbarAction(this, bShow ? 604 : 605);
        }
    }

    private void performImportWorkflowMenuItemAction() {
        if (this.m_propertiesPanel != null) {
            this.m_propertiesPanel.importWorkflow();
        }
    }

    private void performReplaceWorkflowMenuItemAction() {
        if (this.m_propertiesPanel != null) {
            this.m_propertiesPanel.replaceWorkflow();
        }
    }

    private void performRemoveWorkflowMenuItemAction() {
        if (this.m_propertiesPanel != null) {
            this.m_propertiesPanel.deleteSelectedWorkflow();
        }
    }

    private void performScenarioPropertiesMenuItemAction(boolean bDisplay) {
        if (this.m_propertiesPanel != null) {
            this.m_propertiesPanel.displayScenarioPropertiesDialog(bDisplay);
            if (this.m_mainMenuBar.m_scenarioPropertiesMenuItem != null) {
                this.m_mainMenuBar.m_scenarioPropertiesMenuItem.setSelected(bDisplay);
            }
            if (this.m_mainToolbar.m_scenarioPropertiesButton != null) {
                this.m_mainToolbar.m_scenarioPropertiesButton.setSelected(bDisplay);
            }
        }
    }

    private void performPreferencesMenuItemAction() {
        try {
            VWSIMDesignerPreferences preferences = this.m_propertyData.getDesignerPreferences();
            if (preferences != null) {
                VWSIMPreferencesDialog preferenceDlg = new VWSIMPreferencesDialog(this.m_propertyData.getParentFrame());
                preferenceDlg.reinitialize(preferences);
                preferenceDlg.setVisible(true);
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    private void performContentsAndIndexMenuItemAction() {
        try {
            VWSIMHelp.displayPage(VWSIMHelp.Help_Simulation_Designer + "_start_here_designer.htm");
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    private void performAboutMenuItemAction() {
        try {
            ImageIcon icon = VWSIMImageLoader.createImageIcon("simdesigner.gif");
            String productName = VWIDMBaseFactory.instance().getVWString(12).toString();
            VWAboutHelper aboutBox = new VWAboutHelper(this.m_propertyData.getParentFrame(), productName, icon, this.m_propertyData.getSessionInfo());
            aboutBox.display();
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    private boolean isDirty() {
        return this.m_propertiesPanel.isDirty();
    }

    private void resetDirty() {
        this.m_propertiesPanel.resetDirty();
    }

    private void resetIDMDocObjects() {
        this.m_idmDoc = null;
    }

    private void updateTitlebar(String filename) {
        this.m_statusBar.setFilename(filename);
    }

    private void updateTitlebarStatus(String msg) {
        this.m_statusBar.setMessage(msg);
    }

    private void updateIDMTitlebar() {
        if (this.m_idmDoc != null) {
            VWString idmFilenameTemplate = null;
            String docId = null;
            idmFilenameTemplate = this.m_bIsCheckedOut ? VWSIMResource.s_checkedOutPrompt : VWSIMResource.s_copiedPrompt;
            docId = this.m_propertyData.getSessionInfo().isWorkPlaceWebApp() ? this.m_idmDoc.getVersionNumber() : this.m_idmDoc.getIdWithVer();
            this.updateTitlebar(idmFilenameTemplate.toString(this.m_idmDoc.getLabel(), docId));
        } else {
            this.updateTitlebar("");
        }
    }

    private void updateMenuToolbar(int flag) {
        boolean bCanSaveToDMS = this.m_propertyData.getSessionInfo().getCanSaveToDMS();
        this.m_mainToolbar.updateToolbarStatus(flag, bCanSaveToDMS);
        this.m_mainMenuBar.updateMenuStatus(flag, bCanSaveToDMS);
    }

    private void updateBeans(VWScenarioDefinition scenarioDefinition, boolean bNewScenario) {
        Thread.yield();
        if (this.m_propertyData != null) {
            this.m_propertyData.setScenarioDefinition(scenarioDefinition, bNewScenario);
        }
        Thread.yield();
    }

    private void setInitialIDMContext() {
        try {
            if (this.m_propertyData.getVWSession() == null) {
                return;
            }
            VWUserInfo userInfo = this.m_propertyData.getVWSession().fetchCurrentUserInfo();
            if (userInfo == null) {
                return;
            }
            String[] folderList = (String[])userInfo.getFieldValue("sim_console_scope");
            if (folderList == null) {
                return;
            }
            for (int i = 0; i < folderList.length; ++i) {
                IVWIDMItem idmItem = null;
                try {
                    idmItem = VWIDMBaseFactory.instance().getIDMItem(folderList[i]);
                }
                catch (Exception ex1) {
                    // empty catch block
                }
                if (idmItem == null) continue;
                this.m_propertyData.setIDMContext(idmItem);
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }
}

